#ifndef GSTNET
#define GSTNET

var GSTNet_ServerInit(var port);          //initialize server engine
var GSTNet_ServerPoll();  //poll server packets
var GSTNet_Disconnect(var vId);           // disconnects client from server (kick client)
var GSTNet_ClientIP(var vId, STRING* sIP);         // get the ip of the given client
var GSTNet_MyIP(STRING* sIP1, STRING* sIP2, STRING* sIP3, STRING* sIP4); // get the ips of the own running system
var GSTNet_ClientInit(STRING* sIp, var port);      // initialize client engine
var GSTNet_ClientPoll();  // poll client packets
var GSTNet_Exit();          //exits net engine
var GSTNet_ClientSend(var vReceiver, var vType, STRING* sMessage); // send a client packet
var GSTNet_ClientSendData(var vReceiver, var vType, void* pPointer, var nSize); // send a client packet
var GSTNet_ServerSend(var vReceiver, var vType, STRING* sMessage); // send a server packet
var GSTNet_ServerSendFile(var vReceiver, var vType, STRING* sFile); // send a server packet
var GSTNet_TrackVar(STRING* sName);             // tracks a var on server and send it to all clients if changed
var GSTNet_TrackString(STRING* sName);          // tracks a var on server and send it to all clients if changed
var GSTNet_SendVar(var vReceiver, STRING* sName);    // send a var to all clients
var GSTNet_SendArray(var vReceiver, STRING* sName, var vFrom, var vTo); // send a part of a var array  to all clients
var GSTNet_SendString(var vReceiver, STRING* sName);           // send a string to all clients
var GSTNet_SendData(var vReceiver, var vType, void* pPointer, var nSize); // send a server packet
var GSTNet_effect(STRING* sFunctionname, var vNumber, VECTOR* position, VECTOR* speed);  // create a global effect on all clients
var GSTNet_Synchronize(var vMode);               // sync client with server
var GSTNet_SynchronizeEntity(ENTITY* e, var vProperties);         // single ent property sync client with server
var GSTNet_SynchronizeSkills(ENTITY* e, var fromSkill, var toSkill); // single ent skill sync client with server
var GSTNet_Version(STRING* sVersion);           // get GSTNet version
var GSTNet_Timestamp();           // returns GSTNet timestamp in seconds
var GSTNet_SetGlobal(STRING* sField, STRING* sValue); // send a server variable
STRING* GSTNet_GetGlobal(STRING* sField); // get a server variable
var GSTNet_SendGlobals(var vReceiver, STRING* sField); // send a server variable
var GSTNet_WriteGlobals(STRING* sFile); // write globals to sFile
var GSTNet_ReadGlobals(STRING* sFile); // read globals from sFile
var GSTNet_SetSendMode(var vMode); // sets send mode reliable/unreliable
var GSTNet_GetSendMode(); // returns sendmode
var GSTNet_SetVerifyKey(STRING* sMagicKey); // sets the key for verifying data transfer between client+server
//------------------------------------------------------------------
//   player functions
//------------------------------------------------------------------
var GSTNet_SetPlayerValue(var vClientid, STRING* sField, STRING* sValue); // set a player value
var GSTNet_GetPlayerValue(var vClientid, STRING* sField, STRING* sValue); // get a player value
var GSTNet_SendPlayerValues(var vReceiver, var vClientid, STRING* sFields); // send a player value
var GSTNet_SynchronizePlayerValues(var vClientid, STRING* sFields); // synchronize a player value
var GSTNet_WritePlayer(var vClientId, STRING* sFile); // write globals to sFile
var GSTNet_ReadPlayer(var vClientId, STRING* sFile); // read globals from sFile
var GSTNet_LoginPlayer(STRING* sPlayername, STRING* sPassword); // read globals from sFile
var GSTNet_VerifyPlayer(var vClientId); // verifies a player login
var GSTNet_GetPlayerId(STRING* sPlayername); // returns the clientid of the given player or 0


//var GSTNet_KeepAlive(vSecs);          // keeps client alive on server

//------------------------------------------------------------------
//   entity functions
//------------------------------------------------------------------
var GSTNet_ent_create(STRING* sFilename,VECTOR* vector, STRING* eventfunction); // create a global entity on all clients
var GSTNet_ent_createlocal(STRING* filename,VECTOR* vector,STRING* eventfunction); // create a local entity
var GSTNet_ent_remove(ENTITY* e);                         // remove a global entity on all clients
var GSTNet_ent_morph(ENTITY* e, STRING* filename);                         // morphs a global entity on all clients
var GSTNet_TrackEntity(ENTITY* e, var properties);   // track a global entity on all clients
var GSTNet_UntrackEntity(ENTITY* e, var properties);   // track a global entity on server and it to all clients if changed
var GSTNet_TrackSkills(ENTITY* e, var vFromSkill, var vToSkill);   // track skills of a global entity on all clients
var GSTNet_SetTrackIntervall(var vSeconds);   // intervall tracks were sent
var GSTNet_GetTrackIntervall();   // returns actual track intervall in seconds
var GSTNet_SendEntity(var vReceiver, ENTITY* e, var vProperties);   // send a global entity to all clients from any entity on any client or server to all
var GSTNet_SendSkills(var vReceiver, ENTITY* e, var vFromSkill, var vToSkill);   // sends skills of a global entity from server to all clients
var GSTNet_Handle(ENTITY* e); //returns global handle
var GSTNet_PtrForHandle(var handle); //returns entity from global handle
var GSTNet_RegisterEntity(ENTITY* e); //register a wed created entity on server and all clients
//------------------------------------------------------------------
// info functions
//------------------------------------------------------------------
var GSTNet_CreatorId(ENTITY* e); // returns creator of the given entity
var GSTNet_SetCreatorId(ENTITY* e, var vId); // sets creator of the given entity

var GSTNet_ClientId();        // returns an unique id created by the server
var GSTNet_ClientsConnected();// returns the actual connected clients 
var GSTNet_Connection();        // returns 0=no, 1=server 2=client 3=client+server
var GSTNet_Ping();        // returns the last roundtriptime from sending
                                  // a reliable packet to its acknowledgement
var GSTNet_Stats(var vPara);  // returns various statistic info

//------------------------------------------------------------------
// event functions
//------------------------------------------------------------------
var GSTNet_Events(var vType,STRING* sFuncname); // set eventfunction for server/client and user events
#define GSTNet_EventServer 1
#define GSTNet_EventClient 2
#define GSTNet_EventFunction 3
//system event types
#define GSTNet_EvTypeConnect 4  // only on server
#define GSTNet_EvTypeDisconnect 5 // only on server
#define GSTNet_EvTypeFile 6 // only on server
#define GSTNet_EvTypeLogin 7 // only on server
#define GSTNet_EvTypeVar 8
#define GSTNet_EvTypeString 9
#define GSTNet_EvTypeData 10
 

//------------------------------------------------------------------
// helper functions
//------------------------------------------------------------------
var GSTNet_CryptString(STRING* sSrc, STRING* sDest); // en-/decrypts a string
var GSTNet_CryptFile(STRING* sSrcFilename, STRING* sDestFilename); // en-/decrypts a file
var GSTNet_HTTPGetFile(STRING* sHostname,STRING* sPath,STRING* sFilename); //saves a requested http file to disk 
var GSTNet_HTTPGet(STRING* sHostname,STRING* sPath,STRING* sResult); // returns a requested page
var GSTNet_HTTPPost(STRING* sHostname,STRING* sPath,STRING* sData,STRING* sResult); // BETA returns a requested page
var GSTNet_HTTPBusy(); // returns != 0 if a httprequest is busy
var GSTNet_Debug(var vMode);  // 0:disables(default) 1: enables logging via acklog,txt
var GSTNet_Dump();    // dumps entity info to acklog.txt


//bind <GSTNet.dll>;            // bind it for publishing


//------------------------------------------------------------------
// #defines for var GSTNet_TrackEntity and GSTNet_UpdateEntity and GSTNet_SynchronizeEntity;
#define GSTNet_TrackPos 1
#define GSTNet_TrackAngle 2
#define GSTNet_TrackScale 4
#define GSTNet_TrackFlags 8
#define GSTNet_TrackFrame 16
#define GSTNet_TrackSkin 32
#define GSTNet_TrackAmbient 64
#define GSTNet_TrackAlbedo 128
#define GSTNet_TrackAlpha 256
#define GSTNet_TrackLightrange 512
#define GSTNet_TrackColor 1024
#define GSTNet_Trackemask 2048
#define GSTNet_Trackeflags 4096
#define GSTNet_TrackCollisionInfo 8192
//#define GSTNet_TrackStrings 16384;         // not implemented yet
//#define GSTNet_TrackUn#defined 32768;          // not implemented yet
#define GSTNet_TrackAll 65535
//------------------------------------------------------------------

//------------------------------------------------------------------
// #defines for var GSTNet_Stats
#define GSTNet_StatsPassedTime 1
#define GSTNet_StatsRecvBytes 2
#define GSTNet_StatsRecvBytesPerSecond 3
#define GSTNet_StatsSendBytes 4
#define GSTNet_StatsSendBytesPerSecond 5

//------------------------------------------------------------------
// #defines for var GSTNet_Synchronize;
#define GSTNet_SyncEntities 1
#define GSTNet_SyncEntityProperties 2
#define GSTNet_SyncEntitySkills 4
//#define GSTNet_SyncVars 8 //only server side tracked vars 
//#define GSTNet_SyncStrings 16 //only server side tracked strings
#define GSTNet_SyncAll 65535
//------------------------------------------------------------------
// #defines for var GSTNet_?etSendMode
#define GSTNet_SendModeUnreliable 0
#define GSTNet_SendModeReliable 1
//------------------------------------------------------------------

//------------------------------------------------------------------
// various var/string definitions
  STRING* GSTNetMessage = "#256";
  STRING* sGSTNetTemp = "";
  STRING* sGSTNetTemp1 = "";
  STRING* sGSTNetTemp2 = "";
  STRING* sGSTNetTemp3 = "";
  STRING* sGSTNetTemp4 = "";
  var GSTNetId = 0;


void GSTNet_StartClient(STRING* ip, var port, var intervall) {
  GSTNet_ClientInit(ip,port);

  GSTNet_SetTrackIntervall(intervall);

  while (GSTNet_ClientId() <= 0) {
    GSTNet_ClientPoll();
    wait(1);
  }
  GSTNet_Synchronize(GSTNet_SyncAll);
  wait(-0.5);

  GSTNetId = GSTNet_ClientId();
  while(1) { 
    GSTNet_ClientPoll();
    wait(1);
  }
}
void GSTNet_StartServer(var vPort, var vIntervall) {
  GSTNet_ServerInit(vPort);
  
  GSTNet_SetTrackIntervall(vIntervall);
  while(1) {
    GSTNet_ServerPoll();
    wait(1);
  }
}
//------------------------------------------------------------------



#endif     //ifndef GSTNet
